<?php
    /**
    *
    * copyright (c) 2013-2022 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/articolo.php?id=34&alias=linee-guida-per-l%27uso-del-logo-geecom
    */

    $geecomDb = $GLOBALS["geecomDb"];
    $idAbbonamento = filter_input(INPUT_GET,"idAbbonamento",FILTER_SANITIZE_NUMBER_INT);
    $abbonamento   = $geecomDb->leggiSingolaRiga("geecEc_abbonamenti",$idAbbonamento);
    $prodottoOrdinato = $geecomDb->leggiSingolaRiga("geecEc_prodotti",$abbonamento["idProdotto"]);
                                                        
?>
<body>
    <?php 
        echo $inclusioni["inizioBody"];
    ?>
    <div class="wrapper">
	<?php 
	    include "template/include/menuPrincipale.php";
	?>    
        <!-- Contenuto principale  -->
        <div id="content" class="p-0 extramargin d-flex flex-column">
            <div class="page-wrapper">
		<?php 
		    include "template/include/barraSuperiore.php";
		?>
                <main class="py-4">
			<div class="container" >
                            <div class="">
				<h2 class="d-inline-block page-title">Dettagli dell'abbonamento n.  <?php echo $abbonamento["id"]; ?></h2>
                                <a class="d-inline-block float-right btn btn-outline-primary" href="pagina.php?id=5"><i class="fas fa-arrow-left mr-2"></i>Torna indietro</a>
                            </div>
                            
				<div class="card">
                                    <div class="card-body">
                                        <div class="row">

                                              <!-- prima colonna -->
                                              <div id="colonnaPrincipale" class="col-md-5">
                                              <?php 

                                                   $dataRegistrazione = date("d/m/Y",strtotime($abbonamento["dataOrdine"]));
                                                   echo"<div class=\"form-group\">
                                                           <label for=\"partitaIva\" class=\"control-label\">Data registrazione</label>
                                                           <div class=\"\">
                                                             <p>$dataRegistrazione</p>
                                                           </div>
                                                         </div>

                                                         <div class=\"form-group\">
                                                           <label for=\"titoloArticolo\" class=\"control-label\">Ordinante</label>
                                                           <div class=\"\">
                                                             <p class=\"text-primary\">{$abbonamento["destinatario"]}</p>
                                                           </div>
                                                         </div>

                                                         <div class=\"form-group\">
                                                           <label for=\"partitaIva\" class=\"control-label\">Metodo pagamento</label>
                                                           <div class=\"\">
                                                             <p>{$abbonamento["tipoPagamento"]}</p>
                                                           </div>
                                                         </div>";

                                                      $dataCreazione = date("d/m/Y",strtotime($abbonamento["dataOrdine"]));
                                                        if($abbonamento["stato"]=="spedito") {
                                                                $classeBadge = "badge-success";
                                                        }
                                                        else if($abbonamento["stato"]=="annullato") {
                                                                $classeBadge = "badge-danger";
                                                        }
                                                        else {
                                                                $classeBadge = "badge-info";
                                                        }
                                                         echo"<div class=\"form-group\">
                                                           <label for=\"partitaIva\" class=\"control-label\">Stato</label>
                                                           <div class=\"\">
                                                             <span class=\"badge $classeBadge\">{$abbonamento["stato"]}</span>
                                                           </div>
                                                         </div>";

                                                        if($prodottoOrdinato["tipoProdotto"]=="Abbonamento prodotto fisico") {
                                                            echo"<div class=\"form-group\">
                                                                <label for=\"partitaIva\" class=\"control-label\">Tipo di spedizione</label>
                                                                <div class=\"\">
                                                                  <p>{$abbonamento["tipoSpedizione"]}</p>
                                                                </div>
                                                              </div>

                                                              <div class=\"form-group\">
                                                                <label for=\"partitaIva\" class=\"control-label\">Indirizzo di spedizione</label>
                                                                <div class=\"\">
                                                                  <p>{$abbonamento["indirizzoSpedizione"]}, {$abbonamento["citta"]}, {$abbonamento["capSpedizione"]}</p>
                                                                </div>
                                                              </div>";
                                                        }
                                                        
                                                        echo"<div class=\"form-group\">
                                                           <label for=\"partitaIva\" class=\"control-label\">Importo ordine</label>
                                                           <div class=\"\">
                                                             <p>{$abbonamento["importoTotaleOrdine"]} €</p>
                                                           </div>
                                                         </div>

                                                         <div class=\"form-group\">
                                                           <label for=\"partitaIva\" class=\"control-label\">Tipo ricevuta</label>
                                                           <div class=\"\">
                                                             <p>{$abbonamento["tipoRicevuta"]}</p>
                                                           </div>
                                                         </div>";

                                                 ?>

                                              </div>
                                              <!-- /prima colonna --> 

                                              <!-- seconda colonna --> 
                                              <div id="colonnaSecondaria" class="col-md-7">
                                                    <h4 class="text-primary">Prodotto in abbonamento</h4>

                                                    <!-- tabella -->
                                                    <div class="table-responsive">
                                                        <table class="table table-hover table-condensed">
                                                     <thead>
                                                        <tr>
                                                          <th>Oggetto</th>
                                                          <th>Costo unitario</th>
                                                        </tr>
                                                     </thead>
                                                     <tbody>

                                                   <?php 
                                                        if($prodottoOrdinato["idOpzione"]>0) {
                                                            $queryOpzioneOrdinata = "SELECT * FROM geecEc_opzioniAcquisto WHERE id={$prodottoOrdinato["idOpzione"]}";
                                                            if(!$risOpzione = $geecomDb->eseguiQueryLettura($queryOpzioneOrdinata)) {
                                                                echo "Errore nell'esecuzione della query: ".$geecomDb->error;
                                                                exit();
                                                            }
                                                            $opzioneOrdinata = $risOpzione->fetch_assoc();
                                                            echo"<tr>
                                                                <td><a href=../prodotto.php?id={$prodottoOrdinato["idProdotto"]} target=\"_blank\">{$prodottoOrdinato["nomeProdotto"]}  </a> con opzione <a href=creaOpzione.php?id={$opzioneOrdinata["id"]}>{$opzioneOrdinata["nome"]} {$opzioneOrdinata["attributo"]}</a></td>
                                                                <td>{$prodottoOrdinato["prezzoUnitario"]} + {$prodottoOrdinato["prezzoUnitarioOpzione"]}</td>
                                                              </tr>";
                                                         }
                                                         else {
                                                            echo"<tr>
                                                                    <td><a href=../prodotto.php?id={$prodottoOrdinato["idProdotto"]} target=\"_blank\" >{$prodottoOrdinato["nome"]} </a></td>
                                                                    <td>{$prodottoOrdinato["quantita"]}</td>
                                                                    <td>{$prodottoOrdinato["prezzoUnitario"]}</td>
                                                                </tr>";
                                                         }
                                                        
                                                    ?>

                                                     </tbody>
                                                   </table>
                                                 </div>
                                                 <!-- /tabella -->

                                          </div>
                                         <!-- /seconda colonna -->
                                        </div>
                                    </div>
			     	</div>
			</div>

			<?php

			    $queryComponentiDaMostrare = "SELECT c.id, cm.nome, c.testo, c.posizione FROM geecAd_composizionePagine AS c JOIN geecAd_componenti AS cm ON c.idComponente=cm.id WHERE idPagina={$pagina["id"]} ORDER BY c.posizione ASC";
			    $risComponenti = $geecomDb->eseguiQueryLettura($queryComponentiDaMostrare);
			    while($componente = $risComponenti->fetch_assoc()) { 
				 if($componente["nome"]=="Testo") {
				     stampaTesto($componente);
				 }
				 if($componente["nome"]=="Codice html") {
				     stampaCodiceHtml($componente);
				 }
				 if($componente["nome"]=="Immagine a tutto schermo") {
				     stampaImmagine($componente);
				 }
				 if($componente["nome"]=="Includi codice") {
				     includiCodice($componente);
				 }
			    }
			?>
		 </main>
            </div>
	    <?php
		include "template/include/footer.php";
	    ?>
        </div>
    </div>
    <?php
        if($impostazioni["accessoFacebook"]=="si") {
            include "include/facebookSdk.php";
        }

        include"include/includeJsBase.php"; 
        include"template/include/includeJsTemplate.php"; 
        
        echo $inclusioni["fineBody"];
    ?>
</body>